/**
 * oscP5parsing by andreas schlegel
 * example shows how to parse incoming osc messages "by hand".
 * it is recommended to take a look at oscP5plug for an
 * alternative and more convenient way to parse messages.
 * oscP5 website at http://www.sojamo.de/oscP5
 */

import oscP5.*;
import netP5.*;

OscP5 oscP5;
NetAddress myRemoteLocation;

int X, Y;

void setup() {
  size(400, 400);
  /* start oscP5, listening for incoming messages at port 12000 */
  oscP5 = new OscP5(this, 12001);


  /* myRemoteLocation is a NetAddress. a NetAddress takes 2 parameters,
   * an ip address and a port number. myRemoteLocation is used as a parameter in
   * oscP5.send() when sending osc packets to another computer, device, or
   * application. For testing purposes if you make the listening port
   * and the port of the remote location address the same, you will
   * send messages back to this sketch.
   */
  myRemoteLocation = new NetAddress("127.0.0.1", 12000);

  /* osc plug service
   * OSC messages with a specific address pattern can be automatically
   * forwarded to a specific method of an object. In this example 
   * a message with address pattern /test will be forwarded to a method
   * test(). below the method test takes 2 arguments - 2 ints. Therefore each
   * message with address pattern /test and typetag ii will be forwarded to
   * the method test(int theA, int theB)
   */
  oscP5.plug(this, "yourMouse", "/mouseXY");   // name of the method, OSC address pattern
  rectMode(CENTER);
}

void draw() {
  background(0);
  rect(width/2, height/2, X/2, Y/2);
}


// here is the method that is 'plugged'
void yourMouse(int yourMouseX, int yourMouseY) {
  println(yourMouseX, yourMouseY);
  X = yourMouseX;
  Y = yourMouseY;
}


void mousePressed() {
  /* create a new osc message object */
  OscMessage myMessage = new OscMessage("/mouseXY");

  myMessage.add(mouseX); /* add an int to the osc message */
  myMessage.add(mouseY); /* add an int to the osc message */
 
  /* send the message */
  oscP5.send(myMessage, myRemoteLocation);
}